//
//		Definition of the main game class
//
#ifndef THE_VILLAGER_SCENE_H
#define THE_VILLAGER_SCENE_H

#include "../Utils/theSlicedVariableMeter.h"
#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"
#include "../Utils/theVariableMeter.h"
#include "../Utils/theStringManager.h"
#include "../Game/Isola.h"
#include "../Villagers/VillagerManager.h"

class ldwButton;
//class ldwRadioButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;
class theVariableMeter;
class theStringManager;

#define cCheckBoxX 756
#define cCheckBox1Y 213
#define cCheckBox2Y 255
#define cCheckBox3Y 298
#define cCheckBox4Y 341
#define cCheckBox5Y 382

#define cAgeButtonX	290 
#define cAgeButtonY 527
#define cJobButtonX 516
#define cJobButtonY 527
#define cHealthButtonX 740
#define cHealthButtonY 527
#define cSortButtonSize 32

#define maxVillagerNameLength	19  //was 11 before switched to arial

class theVillagerScene : public ldwScene
{
public:

	theVillagerScene();
	~theVillagerScene();

	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);
//	bool ForwardWaitingMessage(StringId whichMessage);

	void UpdateSelection(const int iSelectedVillager);

	void PopulateVillagerList();
	void SortVillagers();
	const bool SortTest(const int iVillager1, const int iVillager2);
	const int FindVillager(const int iVillager);
	void Activate(bool active);

protected:

	void DrawScene();
	void UpdateScene();

private:

	//class enumerations
	enum ESortIndex
	{
		eSortIndex_Age,
		eSortIndex_Health,
		eSortIndex_Skill,
	};

	enum ESortOrder
	{
		eSortOrder_Ascending,
		eSortOrder_Descending
	};

	int m_iVillager[VillagerManager_c_iMaxVillagers];
	int m_iNumVillagers;

	ESortIndex	m_eSortIndex;
	ESortOrder	m_eSortOrder;

	ldwRect ageButtonRect;
	ldwRect jobButtonRect;
	ldwRect healthButtonRect;

	ldwRect motherMouseover;
	ldwRect fatherMouseover;

	const int doneButtonId;
	const int leftArrowButtonId;
	const int rightArrowButtonId;


	ldwButton      *doneButton;
	ldwButton	   *leftArrowButton;
	ldwButton	   *rightArrowButton;

	ldwTextControl *sceneLabel;
	ldwTextControl *skillsLabel;
	ldwTextControl *sortByLabel;
	ldwTextControl *sortAgeLabel;
	ldwTextControl *sortJobLabel;
	ldwTextControl *sortHealthLabel;

	ldwTextControl *playerCommField;

	ldwTextControl *skillFarmLabel;
	ldwTextControl *skillResearchLabel;
	ldwTextControl *skillBreedingLabel;
	ldwTextControl *skillHealingLabel;
	ldwTextControl *skillConstructionLabel;

	ldwTextControl *nameLabel;
	ldwTextControl *nameField;
	ldwTextControl *ageLabel;
	ldwTextControl *ageField;
	ldwTextControl *genderLabel;
	ldwTextControl *genderField;
	ldwTextControl *statusLabel;
	ldwTextControl *statusField;
	ldwTextControl *likesLabel;
	ldwTextControl *likesField;
	ldwTextControl *dislikesLabel;
	ldwTextControl *dislikesField;
	ldwTextControl *pregTimerLabel;
	ldwTextControl *pregTimerField;
};
#endif